<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ============================
// Dashboard Counts
// ============================
$medicineCount = mysqli_fetch_array(
    mysqli_query($con, "SELECT COUNT(*) FROM medicine WHERE expiry_date >= CURDATE()")
)[0];

$invoiceCount = mysqli_fetch_array(
    mysqli_query($con, "SELECT COUNT(*) FROM invoices")
)[0];

$threshold = 20;
$stockAlertCount = mysqli_fetch_array(
    mysqli_query($con, "SELECT COUNT(*) FROM medicine WHERE stock_quantity < $threshold AND status != 'Expired'")
)[0];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Pharmacy | Dashboard</title>

    <!-- Vendor CSS -->
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />

    <style>
        body {
            background: #f4f6f9;
            font-family: 'Lato', sans-serif;
        }

        .card-custom {
            border-radius: 16px;
            color: #fff;
            padding: 25px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform .2s;
        }

        .card-custom:hover {
            transform: scale(1.03);
        }

        .card-bg1 {
            background: linear-gradient(135deg, #667eea, #764ba2);
        }

        .card-bg2 {
            background: linear-gradient(135deg, #56ab2f, #a8e063);
        }

        .card-bg3 {
            background: linear-gradient(135deg, #ff512f, #dd2476);
        }

        .card-icon {
            font-size: 3rem;
            position: absolute;
            top: 20px;
            right: 20px;
            opacity: 0.2;
        }

        .dashboard-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .dashboard-count {
            font-size: 1.8rem;
            font-weight: 700;
        }

        .chart-container {
            height: 250px;
        }
    </style>
</head>

<body>
    <div class="container-scroller">
        <!-- Sidebar -->
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <!-- Header -->
            <?php include('include/header.php'); ?>

            <!-- Main Panel -->
            <div class="main-panel">
                <div class="content-wrapper">

                    <!-- Page Title -->
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Pharmacy | Dashboard</h1>
                            </div>
                        </div>
                    </section>

                    <!-- Dashboard Cards -->
                    <div class="row mt-4 g-4">
                        <div class="col-md-4">
                            <div class="card-custom card-bg1">
                                <i class="fa fa-medkit card-icon"></i>
                                <div class="dashboard-title">Manage Medicine</div>
                                <div class="dashboard-count"><?= $medicineCount ?></div>
                                <a href="manage-medi.php" class="btn btn-light btn-sm mt-3">View</a>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card-custom card-bg2">
                                <i class="fa fa-file-text card-icon"></i>
                                <div class="dashboard-title">Total Invoices</div>
                                <div class="dashboard-count"><?= $invoiceCount ?></div>
                                <a href="manage-invoice.php" class="btn btn-light btn-sm mt-3">View</a>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card-custom card-bg3">
                                <i class="fa fa-exclamation-triangle card-icon"></i>
                                <div class="dashboard-title">Minimum Stock Alert</div>
                                <div class="dashboard-count"><?= $stockAlertCount ?></div>
                                <a href="minimum_stock_alerts.php" class="btn btn-light btn-sm mt-3">View</a>
                            </div>
                        </div>
                    </div>


                </div>
                <!-- Footer -->
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

</body>

</html>